// Adjust.cpp : implementation file
//

#include "stdafx.h"
#include "defsfile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAdjust Dialog


CAdjust::CAdjust(CGpMDoc* pDoc,CWnd* pParent /*=NULL*/)
	: CDialog(CAdjust::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAdjust)
		// 
	//}}AFX_DATA_INIT

	m_pDoc = pDoc ;

	m_dwLight	 = 0 ;
	m_dwContrast = 0 ;

}


void CAdjust::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAdjust)
	DDX_Control(pDX, IDC_Light, m_Light);
	DDX_Control(pDX, IDC_Contrast, m_Contrast);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAdjust, CDialog)
	//{{AFX_MSG_MAP(CAdjust)
	ON_BN_CLICKED(IDSET, OnSet)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAdjust Message Handler

BOOL CAdjust::OnInitDialog() 
{
	DWORD dwContrast,dwLight ;
	int iError ;

	CDialog::OnInitDialog();
	

	// Set Range
	m_Light.SetRange(0,1) ;
	m_Contrast.SetRange(0,7);

	if( m_pDoc->m_bConnected){
		
		if( iError = m_pDoc->MtoMESC_GetContrast(&dwContrast,&dwLight)){
			DispMtoMError( iError,m_pDoc->MtoMGetLastError() ) ;
		} else {
			m_dwContrast = dwContrast ;
			m_dwLight = (dwLight) ? 0 : 1 ;	//	Bright on parameter of API is not equal to Dialog.
		}
	}

	// Set the value to slider
	m_Light.SetPos((int )m_dwLight) ;
	m_Contrast.SetPos((int )m_dwContrast);
	
	return TRUE;  
}


// OK
void CAdjust::OnOK() 
{
	OnSet(); // Set GP the value on Dialog.
	CDialog::OnOK();
}


// Set to GP
void CAdjust::OnSet() 
{
	DWORD dwContrast,dwLight ;
	int iError ;
	CMemSock *pCMemSock ;

	// Set the value	
	dwLight    = (m_Light.GetPos() ) ? 0 : 1 ;		//	Bright on parameter of API is not equal to Dialog.
	dwContrast = m_Contrast.GetPos() ;

	if( pCMemSock = m_pDoc->GetCMemSock() ){
		if( iError = pCMemSock->MtoMESC_SetContrast(dwContrast,dwLight)){
			DispMtoMError( iError,pCMemSock->MtoMGetLastError() ) ;
		}
	}
}
